# NeuralFlow AlphaDeck v2.0 — Free Teaser Pack

## What's Inside

A **free sample** with 60 days of 1-minute data across all 4 asset classes:

| Asset Class | Symbol | Rows | Features | Date Range |
|-------------|--------|------|----------|------------|
| **Crypto** | BTCUSDT | ~43K | 152 | Last 60 days |
| **Equity** | AAPL | ~81K | 115 | Last 60 days |
| **Forex** | EUR_USD | ~61K | 136 | Last 60 days |
| **Indices** | SPX500 | ~54K | 122 | Last 60 days |

**Total: ~238K rows, ~124 MB**

---

## Quick Start

```python
import pandas as pd

# Load any asset class
crypto = pd.read_parquet("teaser/crypto_teaser.parquet")
equity = pd.read_parquet("teaser/equity_teaser.parquet")
forex = pd.read_parquet("teaser/forex_teaser.parquet")
indices = pd.read_parquet("teaser/indices_teaser.parquet")

# Inspect
print(crypto.shape)  # (42687, 152)
print(crypto.columns.tolist()[:10])
```

Or run the **Teaser Notebook**:

```bash
jupyter notebook notebooks/00_teaser_quickstart.ipynb
```

---

## What You Can Validate

✅ **Schema** — 115-152 engineered features per asset class  
✅ **Data Quality** — <5% NaN, proper dtypes, no infinite values  
✅ **ML-Ready** — Train a model in <2 minutes with no preprocessing  
✅ **Signal** — Basic features show predictive power above random  

---

## Full Dataset Comparison

| Tier | Rows | Symbols | Asset Classes | Price |
|------|------|---------|---------------|-------|
| **Teaser** | 238K | 4 | All 4 | **FREE** |
| **Base** | 2.7M | 8 | Crypto | $599 |
| **Pro** | 25.8M | 17 | Crypto + Equity | $1,499 |
| **Enterprise** | 66M | 27 | All 4 | $2,999 |

The teaser is **~0.4% of Enterprise** — same schema, same quality, just less history and fewer symbols.

---

## Files

```
teaser/
├── crypto_teaser.parquet     # BTCUSDT, 152 features
├── equity_teaser.parquet     # AAPL, 115 features
├── forex_teaser.parquet      # EUR_USD, 136 features
├── indices_teaser.parquet    # SPX500, 122 features
├── manifest.json             # Metadata
└── README.md
```

---

## Upgrade Path

After validating with the teaser, choose your tier:

- **Base ($599)** — All 8 crypto symbols, full history 2017-2025
- **Pro ($1,499)** — Add 9 equity symbols (AAPL, MSFT, NVDA, etc.)
- **Enterprise ($2,999)** — Add 6 forex pairs + 4 global indices

All tiers include:
- DuckDB loader for efficient SQL queries
- Jupyter demo notebooks
- "Bring Your Own Feed" API adapter

---

© 2025 QuantLens. All rights reserved.
