# NeuralFlow AlphaDeck v2.0 — Product Catalog

**Premium ML-Ready Feature Datasets for Quantitative Finance**

---

## 🎁 Free Teaser Pack

**Try before you buy.** Download a free sample with 60 days of data across all 4 asset classes.

| Asset Class | Symbol | Rows | Features |
|-------------|--------|------|----------|
| Crypto | BTCUSDT | ~43K | 152 |
| Equity | AAPL | ~81K | 115 |
| Forex | EUR_USD | ~61K | 136 |
| Indices | SPX500 | ~54K | 122 |

**Total: ~238K rows, ~124 MB** — Same schema, same quality as paid tiers.

**What you can validate:**
- ✅ Inspect the full feature schema
- ✅ Run `00_teaser_quickstart.ipynb` in under 5 minutes
- ✅ Train a model to confirm data is ML-ready

📥 **Download:** [NeuralFlow_AlphaDeck_v2.0_TEASER.zip](teaser/)

---

## What is NeuralFlow AlphaDeck?

NeuralFlow AlphaDeck is a curated collection of **1-minute resolution feature datasets** spanning crypto, forex, indices, and equities. Each dataset is pre-engineered with 100+ ML-ready features — no ETL required.

**Why it matters:**
- Skip 3+ months of data wrangling
- Plug directly into scikit-learn, LightGBM, PyTorch
- Battle-tested feature engineering from real quant research

---

## Product Tiers

| Tier | Price | Assets | Rows | Features | Size |
|------|-------|--------|------|----------|------|
| [**Teaser**](#-free-teaser-pack) | **FREE** | 4 symbols | 238K | 115-152 | 124 MB |
| [**Base**](#base-v20) | $599 | Crypto | 2.7M | 152 | 1.3 GB |
| [**Pro**](#pro-v20) | $1,499 | Crypto + Equity | 25.8M | 152/115 | 12 GB |
| [**Enterprise**](#enterprise-v20) | $2,999 | All 4 classes | 66M | 122-152 | 28 GB |

---

## Base v2.0

### *"Your first serious crypto ML model — without 3 months of ETL."*

**Price:** $599

**What You Get:**
- 8 major crypto pairs (BTC, ETH, SOL, BNB, XRP, ADA, DOGE, LINK)
- 2.7M+ bars of 1-minute data (2017–2025)
- 152 pre-computed features per bar

**Feature Highlights:**
| Category | Examples |
|----------|----------|
| Whale Detection | `is_whale`, `whale_bucket` |
| Order Flow | `taker_buy_ratio`, `order_flow_imbalance`, `signed_volume` |
| Microstructure | `kyle_lambda`, `cum_delta`, `price_impact_per_million` |
| Regime Labels | `entropy_regime`, `hurst_regime`, `illiquidity_regime` |
| Volatility | `vol_1h`, `vol_4h`, `vol_24h`, `garch_vol` |
| Technical | SMA, EMA, MACD, Bollinger Bands, momentum |

**Use Cases:**
- Crypto direction prediction (15m / 1h / 4h)
- Whale activity alpha signals
- Volatility regime classification
- Intraday mean reversion models

**Symbols:** `BTCUSDT`, `ETHUSDT`, `SOLUSDT`, `BNBUSDT`, `XRPUSDT`, `ADAUSDT`, `DOGEUSDT`, `LINKUSDT`

---

## Pro v2.0

### *"Cross-asset alpha for people who believe crypto trades like high-beta tech."*

**Price:** $1,499

**What You Get:**
- Everything in Base, plus...
- 9 US equities (AAPL, MSFT, GOOG, AMZN, NVDA, TSLA, SPY, SPXUSD, NSXUSD)
- 23M+ equity bars (2006–2025)
- 115 equity features per bar

**Feature Highlights (Equity):**
| Category | Examples |
|----------|----------|
| Multi-Timeframe Returns | `ret_1m`, `ret_5m`, `ret_15m`, `ret_1h`, `ret_4h`, `ret_1d` |
| Momentum | `mom_5`, `mom_10`, `mom_20`, `mom_60`, `mom_240` |
| Technical | `rsi_14`, `macd`, `macd_signal`, `macd_hist`, `stoch_k` |
| Volume | `vwap`, `volume_ratio`, `volume_sma_20` |
| Volatility | `bb_upper`, `bb_lower`, `bb_pctb`, `atr_14` |
| Cyclical | `hour_sin`, `hour_cos`, `dow_sin`, `dow_cos` |

**Use Cases:**
- BTC-AAPL correlation trading
- Cross-asset momentum strategies
- Regime-aware equity models
- High-frequency equity direction prediction

**Total:** 25.8M rows across 17 symbols

---

## Enterprise v2.0

### *"Multi-asset research lab in a box."*

**Price:** $2,999

**What You Get:**
- Everything in Pro, plus...
- 6 major forex pairs (EUR/USD, GBP/USD, AUD/USD, USD/CAD, EUR/JPY, AUD/JPY)
- 4 global indices (SPX500, DAX30, NKY225, ESTX50)
- 33M+ forex bars (2005–2020)
- 7M+ indices bars (2010–2018)

**Feature Highlights (Forex/Indices):**
| Category | Examples |
|----------|----------|
| Session | `market_session` (Asian/London/NY) |
| Microstructure | `spread_pct`, `tick_count` |
| Cross-Market | Correlation features, cross-asset signals |
| Regime | `vol_regime`, `trend_regime` |

**Use Cases:**
- Global macro regime models
- FX carry + momentum strategies
- Cross-asset correlation analysis
- Multi-asset portfolio optimization
- Regime-switching model training

**Total:** 66M rows across 27 symbols, 4 asset classes

---

## Technical Specifications

| Spec | Value |
|------|-------|
| Resolution | 1-minute bars |
| Format | Apache Parquet (Snappy compression) |
| Timezone | US/Eastern (ET) |
| Loader | DuckDB-based Python helper included |
| Dependencies | `duckdb`, `pandas`, `pyarrow` |

---

## Notebooks Included

| Notebook | Tier | Description |
|----------|------|-------------|
| `00_teaser_quickstart.ipynb` | Teaser | Validate schema & train a quick model |
| `01_crypto_intraday_signal.ipynb` | Base | BTC direction classifier |
| `02_pro_cross_asset_signal.ipynb` | Pro | Cross-asset correlation + dual classifiers |
| `03_enterprise_multiasset_regimes.ipynb` | Enterprise | 4-asset regime analysis |

---

## 🔌 Bring Your Own Price Feed

All paid tiers include `pricefeed_adapter.py` — plug in live data from any API (Binance, Alpaca, OANDA, etc.) without modifying core parquet files.

`python
from pricefeed_adapter import normalize_price_df
from enterprise_loader import EnterpriseLoader

# Normalize your API data
df_live = normalize_price_df(my_api_df, asset_class="crypto", symbol="BTCUSDT")

# Register as queryable view
loader = EnterpriseLoader()
loader.register_price_df("btc_live", df_live)

# Query alongside historical data
loader.query("SELECT * FROM btc_live UNION ALL SELECT * FROM crypto")
`

---

## Quality Assurance

Every dataset ships with:
- ✓ QA Report with null audits, sanity checks, extreme value analysis
- ✓ Verified data lineage (Binance, Stooq, OANDA sources)
- ✓ Spot-checked extreme moves against known market events
- ✓ DuckDB loader with sample queries

---

## Quick Start

`python
# Base tier
from base_loader import BaseLoader
loader = BaseLoader()
df = loader.query("SELECT * FROM crypto WHERE symbol='BTCUSDT' LIMIT 1000")

# Pro tier
from pro_loader import ProLoader
loader = ProLoader()
btc = loader.query("SELECT * FROM crypto WHERE symbol='BTCUSDT'")
aapl = loader.query("SELECT * FROM equity WHERE symbol='AAPL'")

# Enterprise tier
from enterprise_loader import EnterpriseLoader
loader = EnterpriseLoader()
fx = loader.query("SELECT * FROM forex WHERE symbol='EUR_USD'")
`

---

## Upgrade Path

| From | To | You Add |
|------|----|---------|
| Teaser (FREE) | Base ($599) | +7 crypto symbols, full 8-year history |
| Base ($599) | Pro ($1,499) | +9 US equities (23M rows) |
| Pro ($1,499) | Enterprise ($2,999) | +6 FX pairs, +4 indices (40M rows) |

---

## Delivery

- Instant download via secure link
- Parquet files + Python loaders + README + QA docs
- Email support for integration questions

---

## License

Single-seat commercial license. Contact for team/enterprise licensing.

---

## Contact

**QuantLens**
[sales@quantlens.io](mailto:sales@quantlens.io)

---

*© 2025 QuantLens. All rights reserved.*
