﻿# FedFlow Signals – Teaser (2024-10)
This is a one-month demo slice of the full FedFlow Signals Historical dataset.
Period covered:
- award_year: 2024
- award_month: 10 (October)
Source: Extracted from the full FedFlow Signals Historical pack (2005–2025).
What’s inside
- File: data/fedflow_signals_teaser.parquet
- Rows: 2,259 contract awards (October 2024)
  - 100% mapped to public tickers
  - 100% with non-null jump_1d and jump_5d
Columns (subset):
- award_id, award_date, agency, vendor, recipient_uei, ticker, amount
- Flags: sole_source, no_competition, rush_job, incumbent_bias, cost_surge, red_flag_score
- Price impacts: jump_1d, jump_5d
Intended use
- Kick the tires on schema, columns, and data quality
- Quick tests in Python / DuckDB / Spark
- Sanity-check red-flag logic vs price reactions
Not a replacement for the full pack. For serious research/factor/ML, use the full 2005–2025 dataset.
Load examples
- Pandas:
  df = pd.read_parquet("data/fedflow_signals_teaser.parquet")
- DuckDB:
  SELECT * FROM read_parquet('data/fedflow_signals_teaser.parquet') LIMIT 20;
Full product highlights
- 6,521,276 contract awards (2005–2025)
- 100% mapped to tickers
- 1,373,414 observed 5-day price reactions (~21% coverage)
- Twenty-one years of red-flagged contracts + market reactions
Contact the seller to upgrade from the teaser to the full Base or Pro tiers.
