# FedFlow Signals Pro — Marketplace One-Pager

**The Most Dangerous Public Dataset Ever Built**

- 6,521,276 federal contract awards  
- 2005 → 2025  
- 100% mapped to public tickers  
- 1,373,414 observed 5-day price reactions (21% of all rows)

**One-time purchase. No subscription. No API.**  
You buy it. You own it. Forever.

## What you actually get

| Signal                       | Count     | What it means                              |
|------------------------------|-----------|--------------------------------------------|
| sole_source / no_competition | 1.9M+     | Someone got paid without a real fight      |
| rush_job                     | 487k+     | Delivery clock was insane                  |
| incumbent_bias               | 2.4M+     | Same vendor, again and again               |
| cost_surge                   | 312k+     | This award is 3×+ bigger than their previous |
| red_flag_score = 2           | 1,231,000 | Multiple anomalies stacked in one deal     |
| red_flag_score ≥ 3           | 41,000+   | Extreme cases – the outliers you actually study |
| jump_5d non-null             | 1,373,414 | The market actually did something within 5 days |

Every row answers one question: **“This award smells funny — did the stock care?”**

## Two tiers. Zero bullshit.

| Tier | Price  | What you get | Who it’s for |
|------|--------|--------------|--------------|
| Base | $599   | 6.5M contracts + clean ticker mapping + full red-flag feature set | Procurement, compliance, dashboards, OSINT |
| Pro  | $5,999 | Everything in Base + jump_1d / jump_5d returns and price universe linkages | Quants, hedge funds, ML labs, alpha hunters |

One-time. Perpetual license. No redistribution.

## How the returns are handled

- **Included:** Raw 1-day and 5-day forward returns for each mapped ticker.  
- **Uncapped in data:** Crisis spikes, split artifacts, illiquid names stay in the raw distribution.  
- **Marketing-safe view (for display only):**  
  - amount ≥ $1,000,000  
  - red_flag_score ≥ 1  
  - jump_5d non-null  
  - 0.05 ≤ |jump_5d| ≤ 2.0 (5%–200% absolute move)  
- Raw data is untouched; only visuals are tamed.

## Format & tooling

- Delivery: Parquet (year-partitioned: year=2005…2025)  
- Ready for: Python (Pandas / Polars), DuckDB, Spark, Snowflake external tables  
- Includes: schema/column dictionary and QA summary (coverage by year, by flag, by returns)  
- You plug it into your stack and start slicing.

## Why this exists

Governments don’t leak. They sign contracts.  
We took twenty-one years of those signatures and turned them into a structured view of:  
- Who gets paid  
- Under what conditions  
- How the market reacted  

No predictions. No recommendations. Just the tape, cleaned and weaponized for analysis.

## Download options

- Free teaser: 2024–2025 slice (~100k rows) — DM or email  
- Full Pro bundle: ships instantly after payment (link, S3, or direct download)

**FedFlow Signals Pro**  
The vault is open. The silence just got expensive.

[Buy Base – $599] | [Buy Pro – $5,999] | [Request Teaser]

## For quants & ML teams

FedFlow is not a toy dataset. It’s a label factory.

Concrete uses:
- Factor research  
  - Build “government dependency” or “red-flag contract intensity” factors by ticker/sector/time.  
  - Test whether abnormal awards (red_flag_score ≥ 2) predict cross-sectional returns or volatility.
- Event studies  
  - Run pre/post windows (e.g., −10d / +20d) on flagged awards.  
  - Compare reactions for sole-source vs competitive, rush jobs vs normal, cost surges vs steady contracts.
- Label generation for ML  
  - Turn red-flag patterns + price reactions into labels: “flagged award with +X% / −Y% 5-day move”.  
  - Use FedFlow as the outcome layer for models trained on text, order flow, or macro signals.
- Anomaly & risk screens  
  - Screen for names skewed to no-competition awards, repeat incumbency, or large step-ups in award size.  
  - Tag those tickers for PM/risk attention.

Strategy scaffolding, not plug-and-play alpha: clean, time-aligned events + reactions. How you combine them with your universe, costs, and constraints is up to you. No backtest promises, no black box—just 21 years of who got the contract, how weird it was, and what the stock did next.
